package gov.va.vinci.dart.json.builder;

import java.util.List;

import gov.va.vinci.dart.biz.Event;
import gov.va.vinci.dart.biz.EventSummary;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.json.EventRequestView;
import gov.va.vinci.dart.json.EventView;

public class EventRequestViewBuilder {

	private EventViewBuilder eventBuilder = new EventViewBuilder();
	
	public EventRequestView build(final Request request) {
		EventRequestView result = new EventRequestView();
		
		result.setRequestId(request.getId());
		result.setTrackingNumber(request.getTrackingNumber());
		result.setAmendment(request.isAmendment());
		
		for (Event event : request.getEvents()) {
			EventView view = eventBuilder.build(event);
			result.getEvents().add(view);
		}
		
		return result;
	}
	
	public EventRequestView build(List<EventSummary> eventSummaryList) {
		EventRequestView result = new EventRequestView();
		if (eventSummaryList.size() > 0) {
			EventSummary summary = eventSummaryList.get(0);
			result.setRequestId(summary.getRequestId());
			result.setTrackingNumber(summary.getRequestTrackingNumber());
			result.setAmendment(summary.isAmendment());
		}
		
		for (EventSummary summary : eventSummaryList) {
			EventView view = eventBuilder.build(summary);
			result.getEvents().add(view);
		}
		
		return result;
	}

	public EventRequestView build(List<EventSummary> eventSummaryList, int requestId) {
		EventRequestView result = new EventRequestView();
		boolean initialized = false;
		
		for (EventSummary summary : eventSummaryList) {
			if (summary.getRequestId() == requestId) {
				if (initialized == false) {
					result.setRequestId(summary.getRequestId());
					result.setTrackingNumber(summary.getRequestTrackingNumber());
					result.setAmendment(summary.isAmendment());
					initialized = true;
				}
				
				EventView view = eventBuilder.build(summary);
				result.getEvents().add(view);
			}
		}
		
		return result;
	}

}
